<?php
require("../includes/header.php");
require_once("../config/connection.php");

// Fetch app name
$appnameQuery = "SELECT appname FROM app_settings";
$appnameResult = $mysqli->query($appnameQuery);
$appname = $appnameResult ? $appnameResult->fetch_assoc()['appname'] : "App";

// Fetch menu data
$menuQuery = "SELECT id, menu_name, menu_icon, menu_type, is_enabled, toolbar_color FROM app_menu ORDER BY order_id";
$menuResult = $mysqli->query($menuQuery);





?>


<?php if (isset($_GET['success']) && $_GET['success'] == 1): ?>
    <div class="floating-alert alert alert-success">
        Menu item updated successfully!
    </div>
    <style>
        .floating-alert {
            position: fixed; /* Keeps it floating */
            top: 20px; /* Adjust distance from the top */
            right: 20px; /* Adjust distance from the right */
            z-index: 9999; /* Ensure it appears above other elements */
            background-color: #d4edda; /* Success background color */
            color: #155724; /* Success text color */
            padding: 15px 20px; /* Add padding for better spacing */
            border-radius: 8px; /* Rounded corners */
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1); /* Add a subtle shadow */
            animation: fade-in 0.5s ease-in-out; /* Optional: Fade-in effect */
        }

        /* Optional Fade-out animation for auto-hide */
        @keyframes fade-in {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
    </style>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const alert = document.querySelector('.floating-alert');
            if (alert) {
                setTimeout(() => {
                    alert.style.opacity = '0';
                    alert.style.transition = 'opacity 0.5s ease';
                    setTimeout(() => alert.remove(), 500); // Remove element after fade-out
                }, 5000); // Auto-hide after 5 seconds
            }
        });
    </script>
<?php endif; ?>

<?php if (isset($_GET['deletemenu']) && $_GET['deletemenu'] == 1): ?>
    <div class="floating-alert alert alert-danger">
        Menu deleted successfully!
    </div>
    <style>
        .floating-alert {
            position: fixed; /* Keeps it floating */
            top: 20px; /* Adjust distance from the top */
            right: 20px; /* Adjust distance from the right */
            z-index: 9999; /* Ensure it appears above other elements */
            background-color: #d4edda; /* Success background color */
            color: #155724; /* Success text color */
            padding: 15px 20px; /* Add padding for better spacing */
            border-radius: 8px; /* Rounded corners */
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1); /* Add a subtle shadow */
            animation: fade-in 0.5s ease-in-out; /* Optional: Fade-in effect */
        }

        /* Optional Fade-out animation for auto-hide */
        @keyframes fade-in {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
    </style>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const alert = document.querySelector('.floating-alert');
            if (alert) {
                setTimeout(() => {
                    alert.style.opacity = '0';
                    alert.style.transition = 'opacity 0.5s ease';
                    setTimeout(() => alert.remove(), 500); // Remove element after fade-out
                }, 5000); // Auto-hide after 5 seconds
            }
        });
    </script>
<?php endif; ?>


<title>Pages - <?= htmlspecialchars($appname) ?></title>
<meta name="description" content="" />
</head>

<body>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
        <div class="layout-container">
            <!-- Menu -->
            <?php require("../includes/sidebar.php"); ?>
            <!-- / Menu -->

            <!-- Layout container -->
            <div class="layout-page">
                <!-- Navbar -->
                <?php require("../includes/navbar.php"); ?>
                <!-- / Navbar -->

                <!-- Content wrapper -->
                <div class="content-wrapper">
                    <div class="container-xxl flex-grow-1 container-p-y">
                        <h4 class="fw-bold py-3 mb-4">
                            <span class="text-muted fw-light">App /</span> Menu Items
                        </h4>

                        <!-- Navigation -->
                        <ul class="nav nav-pills flex-column flex-md-row mb-3">
                            <li class="nav-item">
                                <a class="nav-link active" href="list_pages.php">
                                    <i class="bx bx-user me-1"></i> View Menu
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="add_menu.php">
                                    <i class="bx bx-bell me-1"></i> Add Menu
                                </a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="menu_sort.php">
                                    <i class="bx bx-link-alt me-1"></i> Rearrange Menu
                                </a>
                            </li>
                        </ul>

                        <!-- Menu Table -->
                        <div class="card">
                            <div class="table-responsive text-nowrap">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Name</th>
                                            <th>Icon</th>
                                            <th>Type</th>
                                            <th>Active</th>
                                            <th>Color</th>
                                            <th>Edit</th>
                                            <th>Delete</th>
                                        </tr>
                                    </thead>
                                    <tbody class="table-border-bottom-0">
                                        <?php if ($menuResult && $menuResult->num_rows > 0): ?>
                                            <?php $index = 1; ?>
                                            <?php while ($row = $menuResult->fetch_assoc()): ?>
                                                <tr id="row_<?= htmlspecialchars($row['id']) ?>">
                                                    <td><strong><?= $index++ ?></strong></td>
                                                    <td><?= htmlspecialchars($row['menu_name']) ?></td>
                                                   <td>
    <div style="height: 1em; width: 1em; overflow: hidden; display: inline-block;">
        <?= ($row['menu_icon']) ?>
    </div>
</td>
                                                    <td>
                                                        <span class="badge bg-label-primary me-1"><?= htmlspecialchars($row['menu_type']) ?></span>
                                                    </td>
                                                    <td><?= $row['is_enabled'] ? "YES" : "NO" ?></td>
                                                    <td><!-- Show color box -->
                    <div style="width: 20px; height: 20px; background-color: <?= htmlspecialchars($row['toolbar_color']) ?>; border: 1px solid #ccc; border-radius: 3px;"></div>
                </td>
                                                    <td>
                                                        <a href="edit_menu.php?id=<?= $row['id'] ?>" class="edit-icon">
                                                            <i class="bx bx-pencil"></i>
                                                        </a>
                                                    </td>
                                                    <td>
                                                        <a href="../functions/delete_menu_item.php?DEL=<?= $row['id'] ?>" class="delete-icon">
                                                            <i class="bx bx-trash"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                            <?php endwhile; ?>
                                        <?php else: ?>
                                            <tr>
                                                <td colspan="8">No data found.</td>
                                            </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                    <!--        </div>-->
                    <!--    </div>-->
                    <!--</div>-->
                <!--</div>-->
            </div>
            <!-- / Content -->
        </div>
    </div>
    
</body>

<?php require("../includes/footer.php"); ?>
</html>
